<?php
// Lógica para obtener los horarios de apertura.
// Esta lógica ahora vive aquí, por lo que cualquier página que incluya este footer
// tendrá acceso a los horarios sin repetir el código.

$dayNames = [
    1 => $translations["Mon"],
    2 => $translations["Tue"],
    3 => $translations["Wed"],
    4 => $translations["Thu"],
    5 => $translations["Fri"],
    6 => $translations["Sat"],
    7 => $translations["Sun"]
];

$sql_opening_hours = "SELECT * FROM opening_hours ORDER BY day ASC";
$opening_hours_result = $conn->query($sql_opening_hours);

$days = [];
if ($opening_hours_result->num_rows > 0) {
    while ($row = $opening_hours_result->fetch_assoc()) {
        $days[] = $row;
    }
}
?>

<div class="footer">
    <div class="container">
        <div class="row gy-4">
            <div class="mt-3"></div>
            <div class="col-md-4 mb-1">
                <h2 class="mb-4">
                    <img src="../assets/img/brand/logo.png" alt="<?php echo htmlspecialchars($business_name); ?> - Logo" height="105">
                </h2>
                <p><?php echo htmlspecialchars($city); ?></p>
                <p><?php echo htmlspecialchars($street); ?> <?php echo htmlspecialchars($hause_no); ?></p>
            </div>
            <div class="col-md-3 offset-md-1">
                <?php if (!empty($days)) : ?>
                    <div class="list-group">
                        <?php foreach ($days as $day) : ?>
                            <div class="list-group-itemcustom d-flex justify-content-between align-items-center">
                                <span><strong><?= htmlspecialchars($dayNames[$day['day']]) ?></strong></span>
                                <span class="text-center justify-content-center">
                                    <?php if (is_null($day['open_time']) && is_null($day['close_time'])) : ?>
                                        <span class="badge bg-danger"><?= $translations["closed"]; ?></span>
                                    <?php else : ?>
                                        <span class="badge bg-success">
                                            <?= date('H:i', strtotime($day['open_time'])) ?> - <?= date('H:i', strtotime($day['close_time'])) ?>
                                        </span>
                                    <?php endif; ?>
                                </span>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-md-2 offset-md-1">
                <h5 class="text-light mb-4"></h5>
            </div>
        </div>
        <div class="border-top border-secondary pt-3 mt-3">
            <p class="small text-center mb-0">
                Copyright © <?php echo $copyright_year; ?> <?php echo htmlspecialchars($business_name); ?> - <?php echo $translations["copyright"]; ?>
                &nbsp;<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="red" class="bi bi-heart-fill" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M8 1.314C12.438-3.248 23.534 4.735 8 15-7.534 4.736 3.562-3.248 8 1.314"></path>
                </svg>
                <a href="https://www.gymoneglobal.com/?lang=<?php echo $lang_code; ?>">GYM One</a>
            </p>
        </div>
    </div>
</div>
</body>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>

</html>