<!DOCTYPE html>
<html lang="<?php echo $lang_code; ?>">

<head>
    <meta charset="UTF-8">
    <title><?php echo $business_name; ?> - Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="/gymprueba/assets/css/dashboard.css">
    <link rel="shortcut icon" href="/gymprueba/assets/img/brand/favicon.png" type="image/x-icon">
</head>
<!-- ApexCharts -->
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>

<body>
    <nav class="navbar navbar-inverse visible-xs">
        <div class="container-fluid">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#myNavbar">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a class="navbar-brand" href="index.php"><img width="70px" src="/gymprueba/assets/img/logo.png" alt="Logo"></a>
            </div>
            <div class="collapse navbar-collapse" id="myNavbar">
                <ul class="nav navbar-nav">
                    <li class="<?php echo (isset($page) && $page === 'inicio') ? 'active' : ''; ?>"><a href="/gymprueba/dashboard/"><i class="bi bi-house"></i> Inicio</a></li>
                    <li class="<?php echo (isset($page) && $page === 'facturas') ? 'active' : ''; ?>"><a href="/gymprueba/dashboard/invoices/"><i class="bi bi-receipt"></i> Facturas</a></li>
                    <li class="<?php echo (isset($page) && $page === 'perfil') ? 'active' : ''; ?>"><a href="/gymprueba/dashboard/profile/"><i class="bi bi-person-badge"></i> Perfil</a></li>
                    <li class="<?php echo (isset($page) && $page === 'estadisticas') ? 'active' : ''; ?>"><a href="/gymprueba/dashboard/stats/"><i class="bi bi-graph-up"></i> Estadísticas</a></li>
                    <li class="<?php echo (isset($page) && $page === 'tienda') ? 'active' : ''; ?>"><a href="/gymprueba/dashboard/tienda/"><i class="bi bi-shop"></i> Tienda</a></li>
                    <li><a href="/gymprueba/dashboard/logout.php"><i class="bi bi-box-arrow-right"></i> Cerrar Sesión</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="row content">
            <div class="col-sm-2 sidenav hidden-xs text-center">
                <h2><img src="/gymprueba/assets/img/brand/logo.png" width="105px" alt="Logo"></h2>
                <p class="lead mb-4 fs-4"><?php echo $business_name ?></p>
                <ul class="nav nav-pills nav-stacked">
                    <li class="sidebar-item <?php echo (isset($page) && $page === 'inicio') ? 'active' : ''; ?>">
                        <a class="sidebar-link" href="/gymprueba/dashboard/">
                            <i class="bi bi-house"></i> Inicio
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo (isset($page) && $page === 'facturas') ? 'active' : ''; ?>">
                        <a class="sidebar-link" href="/gymprueba/dashboard/invoices/">
                            <i class="bi bi-receipt"></i> Facturas
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo (isset($page) && $page === 'perfil') ? 'active' : ''; ?>">
                        <a class="sidebar-link" href="/gymprueba/dashboard/profile/">
                            <i class="bi bi-person-badge"></i> Perfil
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo (isset($page) && $page === 'estadisticas') ? 'active' : ''; ?>">
                        <a class="sidebar-link" href="/gymprueba/dashboard/stats/">
                            <i class="bi bi-graph-up"></i> Estadísticas
                        </a>
                    </li>
                    <li class="sidebar-item <?php echo (isset($page) && $page === 'tienda') ? 'active' : ''; ?>">
                        <a class="sidebar-link" href="/gymprueba/dashboard/tienda/">
                            <i class="bi bi-shop"></i> Tienda
                        </a>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link" href="/gymprueba/dashboard/logout.php">
                            <i class="bi bi-box-arrow-right"></i> Cerrar Sesión
                        </a>
                    </li>
                </ul><br>
            </div>
            <br>
            <div class="col-sm-10">