<?php
// helpers.php

/**
 * Verifica si un usuario tiene un plan activo.
 * Un plan se considera activo si está pagado y no ha vencido.
 *
 * @param mysqli $conn    Conexión a la base de datos
 * @param int    $userid  ID del usuario
 * @return bool
 */
function hasActivePlan($conn, $userid) {
    $sql = "SELECT i.id 
            FROM invoices i
            INNER JOIN tickets t ON i.ticket_id = t.id
            WHERE i.userid = ? 
              AND i.status = 'paid'
              AND NOW() <= DATE_ADD(i.created_at, INTERVAL t.expire_days DAY)
            LIMIT 1";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $userid);
    $stmt->execute();
    $result = $stmt->get_result();

    return ($result->num_rows > 0); // true si tiene plan activo, false si no
}
