<?php
// index.php - Página principal del usuario para ver tickets y productos
// Este archivo muestra los tickets y productos disponibles para compra.
// Asegúrate de que el usuario esté autenticado antes de acceder a esta página.

session_start();

// 1. VERIFICACIÓN DE SESIÓN
if (!isset($_SESSION['userid'])) {
    // Redirige al login si el usuario no está autenticado.
    header("Location: ../../login/");
    exit();
}
ob_start();

// 2. INCLUIR CONFIGURACIÓN Y ESTABLECER VARIABLES DE PÁGINA
require_once '../../config.php';
$userid = $_SESSION['userid'];
$page = 'facturas'; // Identificador para el menú activo

// 3. OBTENER DATOS DE LA PÁGINA

// Obtener nombre y apellido para el mensaje de bienvenida
$sql_user = "SELECT firstname, lastname FROM users WHERE userid = ?";
$stmt_user = $conn->prepare($sql_user);
$stmt_user->bind_param("i", $userid);
$stmt_user->execute();
$stmt_user->bind_result($firstname, $lastname);
$stmt_user->fetch();
$stmt_user->close();

// Obtener las facturas del usuario de forma segura
$sql_invoices = "SELECT id, name, price, created_at, status, route FROM invoices WHERE userid = ? ORDER BY created_at DESC";
$stmt_invoices = $conn->prepare($sql_invoices);
$stmt_invoices->bind_param("i", $userid);
$stmt_invoices->execute();
$result = $stmt_invoices->get_result();

// 4. INCLUIR LA CABECERA DEL DASHBOARD
require_once '../../assets/templates/header-dashboard.php';
require_once '../../config/helpers.php';
?>
<?php if (hasActivePlan($conn, $userid)) : ?>
    <div class="alert alert-warning">
        Ya tienes un plan activo. No podrás comprar otro hasta que expire.
    </div>
<?php endif; ?>

<!-- INICIO DEL CONTENIDO ESPEĆIFICO DE LA PÁGINA -->
<div class="d-none topnav d-sm-inline-block">
    <h4><?php echo htmlspecialchars($translations["welcome"]); ?> <?php echo htmlspecialchars($lastname); ?> <?php echo htmlspecialchars($firstname); ?></h4>
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#logoutModal">
        <?php echo htmlspecialchars($translations["logout"]); ?>
    </button>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title fw-semibold"><?php echo htmlspecialchars($translations["invoicepage"]); ?></h4>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col"><?php echo htmlspecialchars($translations["fullname"]); ?></th>
                                <th scope="col"><?php echo htmlspecialchars($translations["invoiceprice"]); ?></th>
                                <th scope="col"><?php echo htmlspecialchars($translations["date-log"]); ?></th>
                                <th scope="col"><?php echo htmlspecialchars($translations["status"]); ?></th>
                                <th scope="col"><?php echo htmlspecialchars($translations["interact"]); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    $statusClass = $row["status"] == 'paid' ? 'bg-label-success' : 'bg-label-danger';
                                    echo "<tr>
                                        <th scope='row'>" . htmlspecialchars($row["id"]) . "</th>
                                        <td>" . htmlspecialchars($row["name"]) . "</td>
                                        <td>" . htmlspecialchars($row["price"]) . " " . htmlspecialchars($currency) . "</td>
                                        <td>" . htmlspecialchars($row["created_at"]) . "</td>
                                        <td><span class='badge " . htmlspecialchars($statusClass) . "'>" . ucfirst(htmlspecialchars($row["status"])) . "</span></td>
                                        <td>
                                            <td>
                                                <div class='d-flex align-items-center'>
                                                    " . "
                                                    <!-- Botón VER -->
                                                    <a target='_blank' href='/gymprueba/dashboard/invoices/invoice_view.php?invoice_id=" . htmlspecialchars($row["id"]) . "' 
                                                    class='btn btn-primary' title='Ver Factura'>
                                                        <i class='bi bi-eye'></i>
                                                    </a>
                                                    " . "
                                                    <!-- Botón DESCARGAR -->
                                                    <a href='/gymprueba/dashboard/invoices/invoice_download.php?invoice_id=" . htmlspecialchars($row["id"]) . "' 
                                                    class='btn btn-success ms-2' title='Descargar Factura'>
                                                        <i class='bi bi-download'></i>
                                                    </a>
                                                    " . 
                                                    // Mostrar botón Pagar solo si está pendiente
                                                    ($row['status'] == 'unpaid' ? "
                                                        <button type='button' 
                                                                class='btn btn-success ms-2' 
                                                                data-toggle='modal' 
                                                                data-target='#paymentModal' 
                                                                data-invoice-id='" . htmlspecialchars($row["id"]) . "'>
                                                            Pagar Ahora
                                                        </button>
                                                    " : "") . "
                                                </div>
                                        </td>

                                    </tr>";
                                }
                            } else {
                                echo "<tr><td colspan='6'>" . htmlspecialchars($translations["youdonthaveinvoices"]) . "</td></tr>";
                            } 
                            $stmt_invoices->close();
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- FIN DEL CONTENIDO ESPEĆIFICO DE LA PÁGINA -->

<!-- Modal de Pago -->
<div class="modal fade" id="paymentModal" tabindex="-1" aria-labelledby="paymentModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="paymentModalLabel">Seleccionar Método de Pago</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <p>Seleccione su método de pago preferido:</p>

        <!-- Importante: cada botón apunta a su propio archivo de pasarela -->
        <form id="paymentForm" method="GET">
          <input type="hidden" name="invoice_id" id="invoice_id">

          <div class="d-grid gap-2">
            <button type="submit" formaction="mercadopago_payment.php" class="btn" 
              style="background-color: #FFE600; color: #000; border-color: #FFE600;">
              Mercado Pago
            </button>

            <button type="submit" formaction="payu_payment.php" class="btn" 
              style="background-color: #60278D; color: #FFF; border-color: #60278D;">
              PayU Latam
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
$(document).ready(function(){
    $('#paymentModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);  // Botón que abrió el modal
        var invoiceId = button.data('invoice-id'); // extraer el id
        $(this).find('#invoice_id').val(invoiceId); // setear en el input hidden
    });
});
</script>



<?php
// 5. INCLUIR EL PIE DE PÁGINA DEL DASHBOARD
require_once '../../assets/templates/footer-dashboard.php';

ob_end_flush();

?>