<?php
// invoice_template.php
// Este archivo espera que exista un array $invoice con los datos de la factura
// Ejemplo de índices: id, full_name, email, created_at, status, ticket_name, price, amount
// Este archivo recibe $invoice desde invoice_view.php o invoice_download.php
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Factura #<?php echo htmlspecialchars($invoice['id']); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .invoice-box {
            background: #fff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0,0,0,.1);
        }
        .invoice-header {
            border-bottom: 2px solid #0d6efd;
            margin-bottom: 20px;
            padding-bottom: 10px;
        }
        .invoice-footer {
            border-top: 2px solid #0d6efd;
            margin-top: 30px;
            padding-top: 10px;
            text-align: center;
            font-size: 0.9rem;
            color: #6c757d;
        }
        .table th {
            background: #0d6efd;
            color: #fff;
        }
    </style>
</head>
<body>
<div class="container my-5">
    <div class="invoice-box">
        <!-- Encabezado -->
        <div class="invoice-header d-flex justify-content-between align-items-center">
            <h2 class="text-primary">Factura #<?php echo htmlspecialchars($invoice['id']); ?></h2>
            <span><strong>Fecha:</strong> <?php echo date("d/m/Y", strtotime($invoice['created_at'])); ?></span>
        </div>

        <!-- Datos del cliente -->
        <div class="mb-4">
            <h5>Cliente:</h5>
            <p>
                <?php echo htmlspecialchars($invoice['full_name']); ?><br>
                <?php echo htmlspecialchars($invoice['email']); ?><br>
                <?php echo htmlspecialchars($invoice['city']); ?>, 
                <?php echo htmlspecialchars($invoice['street']); ?> 
                <?php echo htmlspecialchars($invoice['house_number']); ?>
            </p>
        </div>

        <!-- Datos del plan -->
        <h5>Detalle de la compra</h5>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Plan/Ticket</th>
                    <th>Duración (días)</th>
                    <th>Sesiones</th>
                    <th>Precio</th>
                    <th>Estado</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo htmlspecialchars($invoice['ticket_name']); ?></td>
                    <td><?php echo htmlspecialchars($invoice['expire_days']); ?></td>
                    <td><?php echo htmlspecialchars($invoice['occasions']); ?></td>
                    <td>$<?php echo number_format($invoice['price'], 2); ?></td>
                    <td>
                        <?php if ($invoice['status'] == 'paid'): ?>
                            <span class="badge bg-success">Pagada</span>
                        <?php else: ?>
                            <span class="badge bg-danger">Pendiente</span>
                        <?php endif; ?>
                    </td>
                </tr>
            </tbody>
        </table>

        <!-- Total -->
        <div class="text-end mt-4">
            <h4>Total: $<?php echo number_format($invoice['price'], 2); ?></h4>
        </div>

        <!-- Pie de factura -->
        <div class="invoice-footer">
            <p>Gracias por confiar en nosotros.  
            Para cualquier consulta, contacte a soporte.</p>
        </div>
    </div>
</div>
</body>

</html>
