<?php
// payu_payment.php
session_start();

if (!isset($_SESSION['userid'])) {
    header("Location: ../../login/");
    exit();
}

// 2. INCLUIR CONFIGURACIÓN Y ESTABLECER VARIABLES DE PÁGINA
require_once '../../config.php'; // conexión BD

// 1. Validar invoice_id
if (!isset($_GET['invoice_id']) || !is_numeric($_GET['invoice_id'])) {
    die("ID de factura no proporcionado o inválido.");
}

$invoice_id = intval($_GET['invoice_id']);

// 2. Consultar factura
// 2. Consultar factura
$sql = "SELECT * FROM invoices WHERE id = ?";
$stmt = $conn->prepare($sql);
if ($stmt === false) {
    die("Error en la consulta: " . $conn->error);
}
$stmt->bind_param("i", $invoice_id);
$stmt->execute();
$result = $stmt->get_result();
$invoice = $result->fetch_assoc();

// ✅ Validación unificada
if (!$invoice || $invoice['status'] !== 'unpaid') {
    die("Factura no encontrada o no disponible para pago.");
}

// 4. Simular redirección al checkout_dummy.php con POST
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Redirigiendo a Checkout...</title>
</head>
<body>
    <p>Redirigiendo a la pasarela de pago ficticia (PayU)...</p>
    <form id="redirectForm" method="POST" action="../../dashboard/invoices/checkout_dummy.php">
        <input type="hidden" name="invoice_id" value="<?php echo htmlspecialchars($invoice_id); ?>">
        <input type="hidden" name="gateway" value="PayU">
    </form>
    <script>
        document.getElementById('redirectForm').submit();
    </script>
</body>
</html>