<?php
session_start();

// 1. VERIFICACIÓN DE SESIÓN
if (!isset($_SESSION['userid'])) {
    header("Location: ../../login/");
    exit();
}

// 2. INCLUIR CONFIGURACIÓN Y ESTABLECER VARIABLES DE PÁGINA
require_once '../../config.php';
$userid = $_SESSION['userid'];
$page = 'estadisticas'; // Identificador para el menú activo

// 3. OBTENER DATOS PARA LAS ESTADÍSTICAS

// Obtener nombre de usuario
$sql_user = "SELECT firstname, lastname FROM users WHERE userid = ?";
$stmt_user = $conn->prepare($sql_user);
$stmt_user->bind_param("i", $userid);
$stmt_user->execute();
$stmt_user->bind_result($lastname, $firstname);
$stmt_user->fetch();
$stmt_user->close();

// --- Lógica para calcular estadísticas (se mantiene igual) ---
$sql_latest_session = "SELECT duration FROM workout_stats WHERE userid = ? AND workout_date = CURDATE()";
// ... (resto de la lógica de consulta de estadísticas)
$dates = [];
$durations = [];
for ($i = 29; $i >= 0; $i--) {
    $date = date('Y-m-d', strtotime("-$i days"));
    $dates[$date] = 0;
}
$sql_workouts = "SELECT workout_date, duration FROM workout_stats WHERE userid = ? AND workout_date >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)";
$stmt_workouts = $conn->prepare($sql_workouts);
$stmt_workouts->bind_param("i", $userid);
$stmt_workouts->execute();
$result_workouts = $stmt_workouts->get_result();
if ($result_workouts->num_rows > 0) {
    while ($row = $result_workouts->fetch_assoc()) {
        $dates[$row['workout_date']] = $row['duration'];
    }
}
$stmt_workouts->close();
$chart_dates = array_keys($dates);
$chart_durations = array_values($dates);
// --- Fin de la lógica de estadísticas ---

// 4. INCLUIR LA CABECERA DEL DASHBOARD
require_once '../../assets/templates/header-dashboard.php';
?>

<!-- INICIO DEL CONTENIDO ESPEĆIFICO DE LA PÁGINA -->
<div class="d-none topnav d-sm-inline-block">
    <h4><?php echo htmlspecialchars($translations["welcome"]); ?> <?php echo htmlspecialchars($lastname); ?> <?php echo htmlspecialchars($firstname); ?></h4>
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#logoutModal">
        <?php echo htmlspecialchars($translations["logout"]); ?>
    </button>
</div>

<div class="row">
    <!-- Tarjetas de estadísticas -->
    <div class="col-sm-4">
        <!-- ... (tarjeta de última sesión) ... -->
    </div>
    <div class="col-sm-4">
        <!-- ... (tarjeta de tiempo promedio) ... -->
    </div>
    <div class="col-sm-4">
        <!-- ... (tarjeta de último entrenamiento) ... -->
    </div>
</div>

<div class="row">
    <!-- Gráfico de ApexCharts -->
    <div class="col-sm-8">
        <div class="card shadow">
            <div class="card-body text-start">
                <h4 class="card-title fw-semibold">
                    <?php echo htmlspecialchars($translations["thirtydaychart"]); ?>
                </h4>
                <div id="chart"></div>
            </div>
        </div>
    </div>
</div>

<!-- Script del gráfico (específico de esta página) -->
<script>
    var dates = <?php echo json_encode($chart_dates); ?>;
    var durations = <?php echo json_encode($chart_durations); ?>;

    var options = {
        chart: {
            type: 'line',
            height: 350,
            zoom: { enabled: false },
            toolbar: { show: false }
        },
        stroke: { curve: 'smooth' },
        colors: ['#59F8E4'],
        series: [{
            name: '<?php echo htmlspecialchars($translations["chartminutestraintime"]); ?>',
            data: durations
        }],
        xaxis: {
            categories: dates,
            labels: { rotate: -45 }
        },
        yaxis: { min: 0 },
    };

    var chart = new ApexCharts(document.querySelector("#chart"), options);
    chart.render();
</script>
<!-- FIN DEL CONTENIDO ESPEĆIFICO DE LA PÁGINA -->

<?php
// 5. INCLUIR EL PIE DE PÁGINA DEL DASHBOARD
require_once '../../assets/templates/footer-dashboard.php';
?>