<?php
session_start();

if (!isset($_SESSION['userid'])) {
    header("Location: ../../login/");
    exit();
}

require_once '../../config.php';
require_once '../../config/helpers.php';

$userid = $_SESSION['userid'];
$page = 'tienda'; // menú activo

// --- INFO DEL USUARIO ---
$sql_user = "SELECT firstname, lastname FROM users WHERE userid = ?";
$stmt_user = $conn->prepare($sql_user);
$stmt_user->bind_param("i", $userid);
$stmt_user->execute();
$stmt_user->bind_result($firstname, $lastname);
$stmt_user->fetch();
$stmt_user->close();

// --- PLANES / MEMBRESÍAS ---
$sql_tickets = "SELECT * FROM tickets";
$tickets_result = $conn->query($sql_tickets);

// --- PRODUCTOS ---
$sql_products = "SELECT * FROM products";
$products_result = $conn->query($sql_products);

require_once '../../assets/templates/header-dashboard.php';
?>

<div class="d-none topnav d-sm-inline-block">
    <h4><?php echo htmlspecialchars($translations["welcome"]); ?> <?php echo htmlspecialchars($lastname); ?> <?php echo htmlspecialchars($firstname); ?></h4>
    <?php
    if (isset($_SESSION['alert_message'])) {
        $alert_type = $_SESSION['alert_message']['type'];
        $alert_message = $_SESSION['alert_message']['message'];
        echo "<div class='alert alert-$alert_type alert-dismissible fade show' role='alert'>";
        echo $alert_message;
        echo "<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>";
        echo "</div>";
        unset($_SESSION['alert_message']);
    }
    ?>
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#logoutModal">
        <?php echo htmlspecialchars($translations["logout"]); ?>
    </button>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-body">
                <!-- ================= PLANES ================= -->
                <h4 class="card-title fw-semibold">Planes / Membresías</h4>
                <div class="row mt-3">
                    <?php
                    if ($tickets_result->num_rows > 0) {
                        while ($row = $tickets_result->fetch_assoc()) {
                            echo "<div class='col-sm-4 mb-4'>";
                            echo "<div class='card shadow-sm border-light h-100'>";
                            echo "<div class='card-body d-flex flex-column'>";
                            echo "<h5 class='card-title text-first'>" . htmlspecialchars($row["name"]) . "</h5>";
                            echo "<p class='card-text'>Duración de vencimiento (en días): " . htmlspecialchars($row["expire_days"]) . "</p>";
                            echo "<p class='card-text'>Número de ocasiones: " . htmlspecialchars($row["occasions"]) . "</p>";
                            echo "<p class='card-text'><strong>Precio: " . htmlspecialchars($row["price"]) . " " . htmlspecialchars($currency) . "</strong></p>";

                            if (hasActivePlan($conn, $userid)) {
                                echo "<button class='btn btn-secondary w-100' disabled>Ya tienes un plan activo</button>";
                            } else {
                                echo "<form action='process_payment.php' method='POST' class='mt-auto'>";
                                echo "<input type='hidden' name='ticket_id' value='" . htmlspecialchars($row["id"]) . "'>";
                                echo "<button type='submit' class='btn btn-success w-100'>" . htmlspecialchars($translations["paybutton"]) . "</button>";
                                echo "</form>";
                            }

                            echo "</div>";
                            echo "</div>";
                            echo "</div>";
                        }
                    } else {
                        echo "<div class='col-12'><div class='alert alert-warning'>No hay planes disponibles</div></div>";
                    }
                    ?>
                </div>
                <div class="d-flex justify-content-end mb-3">
                    <a href="cart.php" class="btn btn-warning">
                        🛒 Ver Carrito
                    </a>
                </div>

                <!-- ================= PRODUCTOS ================= -->
                <h4 class="card-title fw-semibold mt-5">Productos</h4>
                <div class="row mt-3">
                    <?php
                    if ($products_result->num_rows > 0) {
                        while ($row = $products_result->fetch_assoc()) {
                            echo "<div class='col-sm-4 mb-4'>";
                            echo "<div class='card shadow-sm border-light h-100'>";
                            echo "<div class='card-body d-flex flex-column'>";
                            echo "<h5 class='card-title text-first'>" . htmlspecialchars($row["name"]) . "</h5>";
                            echo "<p class='card-text'>" . htmlspecialchars($row["description"]) . "</p>";
                            echo "<p class='card-text'><strong>Precio: " . htmlspecialchars($row["price"]) . " " . htmlspecialchars($currency) . "</strong></p>";
                            echo "<p class='card-text'>Stock disponible: " . htmlspecialchars($row["stock"]) . "</p>";

                            echo "<form action='add_to_cart.php' method='POST' class='mt-auto'>";
                            echo "<input type='hidden' name='product_id' value='" . htmlspecialchars($row["id"]) . "'>";
                            echo "<input type='number' name='quantity' value='1' min='1' class='form-control mb-2' style='max-width:100px;' required>";
                            echo "<button type='submit' class='btn btn-primary w-100'>" . $translations["paybutton"] . "</button>";
                            echo "</form>";


                            echo "</div>";
                            echo "</div>";
                            echo "</div>";
                        }
                    } else {
                        echo "<div class='col-12'><div class='alert alert-warning'>No hay productos disponibles</div></div>";
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
require_once '../../assets/templates/footer-dashboard.php';
?>


