<?php
session_start();

// 1. Incluir el archivo de configuración centralizado
require_once '../config.php';

// 2. Lógica específica de la página
$pageTitle = $translations["confirmemailpage"];
$currentPage = 'confirm';
$confirmation_message = '';

if (isset($_GET['userid'])) {
    $userid = $_GET['userid'];

    $sql = "UPDATE users SET confirmed = 'Yes' WHERE userid = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $userid);

    if ($stmt->execute()) {
        $confirmation_message = '<div class="alert alert-success mt-5" role="alert">'. $translations["regconfirm"] .'</div>';
    } else {
        $confirmation_message = '<div class="alert alert-danger mt-5" role="alert">' . $translations["errorconfirm"] . $conn->error . '</div>';
    }

    $stmt->close();
} else {
    $confirmation_message = '<div class="alert alert-warning mt-5" role="alert">' . $translations["errornoparameter"]. '</div>';
}

$conn->close();

// 3. Incluir el contenido de la página
require_once __DIR__ . '/../templates/pages/confirm.php';

?>