<!DOCTYPE html>
<html lang="<?php echo $lang_code; ?>">

<head>
    <meta charset="UTF-8">
    <title><?php echo $business_name; ?> - <?php echo $translations["register"]; ?></title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/css/login-register.css">
    <link rel="shortcut icon" href="../assets/img/brand/favicon.png" type="image/x-icon">
</head>

<body>
    <div id="register">
        <div class="container">
            <div class="row justify-content-center pt-4">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="text-center">
                                <h2><?php echo $translations["login"]; ?></h2>
                                <img class="img mb-3 mt-3 img-fluid" src="../assets/img/brand/logo.png" title="<?php echo $business_name; ?>" alt="<?php echo $business_name; ?>">
                            </div>
                            <?php if (!empty($login_error)) : ?>
                                <div class="alert alert-danger"><?php echo $login_error; ?></div>
                            <?php endif; ?>
                            <?php if (!empty($alerts_html)) : ?>
                                <?php echo $alerts_html; ?>
                            <?php endif; ?>

                            <form method="POST">
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="firstname"><?php echo $translations["firstname"]; ?></label>
                                        <input type="text" class="form-control" id="firstname" name="firstname" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="lastname"><?php echo $translations["lastname"]; ?></label>
                                        <input type="text" class="form-control" id="lastname" name="lastname" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="email"><?php echo $translations["email"]; ?></label>
                                    <input type="email" class="form-control" id="email" name="email" required>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="password"><?php echo $translations["password"]; ?></label>
                                        <input type="password" class="form-control" id="password" name="password" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="confirm_password"><?php echo $translations["password-confirm"]; ?></label>
                                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="gender"><?php echo $translations["gender"]; ?></label>
                                    <select class="form-control" id="gender" name="gender" required>
                                        <option value="Male"><?php echo $translations["boy"]; ?></option>
                                        <option value="Female"><?php echo $translations["girl"]; ?></option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="birthdate"><?php echo $translations["birthday"]; ?></label>
                                    <input type="date" class="form-control" id="birthdate" name="birthdate" required>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-5">
                                        <label for="city"><?php echo $translations["city"]; ?></label>
                                        <input type="text" class="form-control" id="city" name="city" required>
                                    </div>
                                    <div class="form-group col-md-5">
                                        <label for="street"><?php echo $translations["street"]; ?></label>
                                        <input type="text" class="form-control" id="street" name="street" required>
                                    </div>
                                    <div class="form-group col-md-2">
                                        <label for="house_number"><?php echo $translations["hause-no"]; ?></label>
                                        <input type="number" class="form-control" id="house_number" name="house_number" required>
                                    </div>
                                </div>
                                <iframe src="../admin/boss/rule/rule.html" width="100%" height="200px" frameborder="0"></iframe>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault" required>
                                    <label class="form-check-label" for="flexCheckDefault">
                                        <?php echo $translations["acceptrules"]; ?>
                                    </label>
                                </div>
                                <button type="submit" class="btn btn-primary"><?php echo $translations["register"]; ?></button>
                            </form>
                            <div class="text-start mt-1">
                                <small><?php echo $translations["doyouhaveaccount"]; ?> <span><a href="../login/"><?php echo $translations["login"]; ?></a></span></small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 319">
        <path fill="whitesmoke" fill-opacity="1" d="M0,64L1440,192L1440,320L0,320Z"></path>
    </svg>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
</body>

</html>